/**
 * Mozello Catalog Cart Actions
 */
function mozCatalogCart()
{
    this.country = null;
    this.initActionButtons();
}

/*** Init ***/

mozCatalogCart.prototype.initActionButtons = function()
{
    $(".moze-add-to-cart.moze-added-to-cart")
        .attr("href", "javascript:;")
        .off();

    $(".moze-add-to-cart:not(.moze-added-to-cart)").each((index, button) => {

        button = $(button);

        // Step 1

        let slot = button.parents(".cat-thumb");
        if (slot.length != 1) {
            return;
        }

        let catItemID = slot.attr("data-cat-item-id");
        if (typeof catItemID == "undefined" || catItemID < 1) {
            return null;
        }

        if (typeof mozCatItems == "undefined") {
            return null;
        }

        let mozCatItem = mozCatItems.find(item => item.id == catItemID) || null;

        if (!mozCatItem) {
            return null;
        }

        // Step 2

        let isAvailable =
            mozCatItem.stock === null ||
            mozCatItem.stock > 0;

        if (isAvailable) {
            button.attr("href", "javascript:;");
            button.html(
                mozCatItem.bookings_service_id > 0
                    ? mozLocalization.cmBooking
                    : mozLocalization.cmCatalogCartAdd
            );
        }
        else {
            button
                .attr("href", $(slot).attr("data-cat-item-link"))
                .html(mozLocalization.cmCatalogCartView);
        }

        // Step 3

        button.off();

        if (!isAvailable) {
            return;
        }

        let thumbnail = button.parents('.cat-thumb[data-cat-item-link]');

        if (mozCatItem.bookings_service_id == 0 || mozCatItem.bookings_service_id == null) {
            this.initAddToCart(mozCatItem, button, thumbnail);
        }
        else {
            this.initBooking(mozCatItem, button, thumbnail);
        }
    });
}

mozCatalogCart.prototype.initAddToCart = function(item, button, thumbnail)
{
    button
        .off()
        .on("click", (event) => {
            this.actionAddToCart(item, null, null, () => {
                this.triggerAddedToCartEvent(item, button, thumbnail);
            });
        });
}

mozCatalogCart.prototype.initBooking = function(item, button, thumbnail)
{
    let widget = null,
        widgetOptions = {};

    new mozLive3({
        source: {
            name: 'maincatalog',
            superglobal: 1
        },
        action: 'catalog-booking-init',
        parameters: {
            service: item.bookings_service_id
        },
        response: {
            callback: [
                (response) => {

                    widgetOptions = {

                        type: response.data.type,

                        minDaysRange: response.data.minDaysRange,
                        maxDaysRange: response.data.maxDaysRange,

                        mozLive3Parameters: {
                            componentName: 'maincatalog',
                            componentSuperglobal: 1,
                            serviceID: item.bookings_service_id,
                            onWidgetInitializedAction: 'catalog-booking-date-from',
                            onDateFromSelectedAction: 'catalog-booking-time-from',
                            onTimeFromSelectedActions: 'catalog-booking-date-to',
                            onDateToSelectedAction: 'catalog-booking-time-to',
                        },

                        onSubmit: (widget, result) => {

                            let deferred = $.Deferred();
                            deferred.resolve(true);

                            let bookingRequest = result;
                            bookingRequest.serviceID = item.bookings_service_id;
                            bookingRequest.service = 'Event';

                            new mozLive3({
                                source: {
                                    name: 'maincatalog',
                                    superglobal: 1
                                },
                                action: 'catalog-booking-draft',
                                parameters: {
                                    booking: bookingRequest
                                },
                                response: {
                                    callback: [
                                        (response) => {

                                            if (response.error) {
                                                console.warn(response.errorMessage);
                                                return;
                                            }

                                            if (response.data.success != true) {
                                                alert('Booking not available anymore!');
                                                return;
                                            }

                                            this.actionAddToCart(item, response.data.token, bookingRequest, () => {
                                                this.triggerAddedToCartEvent(item, button, thumbnail);
                                            });
                                        }
                                    ]
                                }
                            });

                            return deferred.promise();
                        }
                    }

                    widget = new BookingWidget(widgetOptions);
                }
            ]
        }
    });

    button
        .off()
        .on("click", (event) => {
            if (widget) {
                widget.show();
            }
        });
}

/*** Actions ***/

mozCatalogCart.prototype.actionAddToCart = function(item, bookingToken, bookingRequest, onComplete)
{
    let mozAddToCartFx = function(country) {
        new mozLive3({
            source: {
                name: "maincatalog",
                superglobal: 1
            },
            action: "catalog-add-to-cart",
            parameters: {
                cat_item_id: item.id,
                cat_item_variant_id: 0,
                cat_item_variant_text: '',
                country: country,
                token: bookingToken,
                booking: bookingRequest
            },
            response: {
                html: [
                    { name: "maincatalogcartside", target: "#shopbar-sidecart-base" }
                ]
            },
            errors: {
                maintenance: mozLocalization.erInMaintenanceMode
            },
            onComplete: () => {
                if (typeof onComplete === 'function') {
                    onComplete();
                }
            }
        });
    };

    if (this.country == null) {
        $.ajax({
            url: 'https://www.mozello.com/apps/geo/',
            success: (response) => {
                this.country = response.country;
                mozAddToCartFx(this.country);
            }
        });
    }
    else {
        mozAddToCartFx(this.country);
    }
}

mozCatalogCart.prototype.triggerAddedToCartEvent = function(item, button, thumbnail)
{
    initCart();
    if ($(".shopbar-cart").is(":visible") && !$("#shopbar-sidecart").is(":visible")) {
        $(".shopbar-cart").first().trigger("click");
    }
    syncCartToLocalStorage();

    $(button)
        .addClass("moze-added-to-cart")
        .html(mozLocalization.cmCatalogCartAdded);

    let itemLink = thumbnail.attr('data-cat-item-link');
    if (itemLink) {
        $(button)
            .off("click")
            .attr("href", itemLink);
    }

    if (typeof item.pixel !== 'undefined') {
        this.triggerGtagEvent(
            item.pixel.id,
            item.pixel.name,
            item.pixel.brand,
            item.pixel.category,
            item.pixel.currency,
            item.pixel.price,
            1
        );
        this.triggerFbqEvent(
            item.pixel.id,
            item.pixel.currency,
            item.pixel.price,
            1
        );
    }
}

mozCatalogCart.prototype.triggerGtagEvent = function(id, name, brand, category, currency, price, quantity)
{
    if (typeof gtag != "function") {
        return;
    }

    gtag("event", "add_to_cart", {
        currency: currency,
        items: [{
            id: id,
            name: name,
            brand: brand,
            category: category,
            price: price,
            quantity: quantity
        }],
        value: price * quantity
    });
}

mozCatalogCart.prototype.triggerFbqEvent = function(id, currency, price, quantity)
{
    if (typeof fbq != "function") {
        return;
    }

    fbq("track", "AddToCart", {
        content_ids: [id],
        content_type: "product",
        contents: [{ id: id, quantity: quantity }],
        currency: currency,
        value: price * quantity
    });
}

/*** Initialization ***/

function reinitMozCatalogCartActions()
{
    new mozCatalogCart();
}

$(document).ready(function() {
    reinitMozCatalogCartActions();
});

/*** End ***/